#ifndef RENDERER_H
#define RENDERER_H
#include "Config.h"

#include <vector>

#include "Graphics.h"
#include "gui/interface/Point.h"

class RenderPreset;
class Simulation;

struct gcache_item
{
	int isready;
	int pixel_mode;
	int cola, colr, colg, colb;
	int firea, firer, fireg, fireb;
	gcache_item() :
	isready(0),
	pixel_mode(0),
	cola(0),
	colr(0),
	colg(0),
	colb(0),
	firea(0),
	firer(0),
	fireg(0),
	fireb(0)
	{
	}
};
typedef struct gcache_item gcache_item;

class Renderer
{
public:
	Simulation * sim;
	Graphics * g;
	gcache_item *graphicscache;

	std::vector<unsigned int> render_modes;
	unsigned int render_mode;
	unsigned int colour_mode;
	std::vector<unsigned int> display_modes;
	unsigned int display_mode;
	std::vector<RenderPreset> renderModePresets;
	//
	unsigned char fire_r[YRES/CELL][XRES/CELL];
	unsigned char fire_g[YRES/CELL][XRES/CELL];
	unsigned char fire_b[YRES/CELL][XRES/CELL];
	unsigned int fire_alpha[CELL*3][CELL*3];
	//
	bool gravityZonesEnabled;
	bool gravityFieldEnabled;
	int decorations_enable;
	bool blackDecorations;
	bool debugLines;
	pixel sampleColor;
	int findingElement;
	int foundElements;

	//Mouse position for debug information
	ui::Point mousePos;

	//Zoom window
	ui::Point zoomWindowPosition;
	ui::Point zoomScopePosition;
	int zoomScopeSize;
	bool zoomEnabled;
	int ZFACTOR;

	//Renderers
	void RenderBegin();
	void RenderEnd();

	void RenderZoom();
	void DrawBlob(int x, int y, unsigned char cr, unsigned char cg, unsigned char cb);
	void DrawWalls();
	void DrawSigns();
	void render_gravlensing(pixel * source);
	void render_fire();
	void prepare_alpha(int size, float intensity);
	void render_parts();
	void draw_grav_zones();
	void draw_air();
	void draw_grav();
	void draw_other();
	void FinaliseParts();

	void ClearAccumulation();
	void clearScreen(float alpha);
	void SetSample(int x, int y);

	pixel * vid;
	pixel * persistentVid;
	pixel * warpVid;
	void blendpixel(int x, int y, int r, int g, int b, int a);
	void addpixel(int x, int y, int r, int g, int b, int a);

	void draw_icon(int x, int y, Icon icon);

	int drawtext_outline(int x, int y, const String &s, int r, int g, int b, int a);
	int drawtext(int x, int y, const String &s, int r, int g, int b, int a);
	int drawchar(int x, int y, String::value_type c, int r, int g, int b, int a);
	int addchar(int x, int y, String::value_type c, int r, int g, int b, int a);

	void xor_pixel(int x, int y);
	void xor_line(int x, int y, int x2, int y2);
	void xor_rect(int x, int y, int width, int height);
	void xor_bitmap(unsigned char * bitmap, int x, int y, int w, int h);

	void draw_line(int x, int y, int x2, int y2, int r, int g, int b, int a);
	void drawrect(int x, int y, int width, int height, int r, int g, int b, int a);
	void fillrect(int x, int y, int width, int height, int r, int g, int b, int a);
	void drawcircle(int x, int y, int rx, int ry, int r, int g, int b, int a);
	void fillcircle(int x, int y, int rx, int ry, int r, int g, int b, int a);
	void clearrect(int x, int y, int width, int height);
	void gradientrect(int x, int y, int width, int height, int r, int g, int b, int a, int r2, int g2, int b2, int a2);

	void draw_image(const pixel *img, int x, int y, int w, int h, int a);
	void draw_image(const VideoBuffer * vidBuf, int w, int h, int a);

	VideoBuffer DumpFrame();

	void drawblob(int x, int y, unsigned char cr, unsigned char cg, unsigned char cb);

	pixel GetPixel(int x, int y);
	//...
	//Display mode modifiers
	void CompileDisplayMode();
	void CompileRenderMode();
	void AddRenderMode(unsigned int mode);
	void SetRenderMode(std::vector<unsigned int> render);
	std::vector<unsigned int> GetRenderMode();
	void RemoveRenderMode(unsigned int mode);
	void AddDisplayMode(unsigned int mode);
	void RemoveDisplayMode(unsigned int mode);
	void SetDisplayMode(std::vector<unsigned int> display);
	std::vector<unsigned int> GetDisplayMode();
	void SetColourMode(unsigned int mode);
	unsigned int GetColourMode();

	void ResetModes();

	int GetGridSize() { return gridSize; }
	void SetGridSize(int value) { gridSize = value; }

	static VideoBuffer * WallIcon(int wallID, int width, int height);

	Renderer(Graphics * g, Simulation * sim);
	~Renderer();

#define RENDERER_TABLE(name) \
	static std::vector<pixel> name; \
	static inline pixel name ## At(int index) \
	{ \
		auto size = int(name.size()); \
		if (index <        0) index =        0; \
		if (index > size - 1) index = size - 1; \
		return name[index]; \
	}
	RENDERER_TABLE(flameTable)
	RENDERER_TABLE(plasmaTable)
	RENDERER_TABLE(heatTable)
	RENDERER_TABLE(clfmTable)
	RENDERER_TABLE(firwTable)
#undef RENDERER_TABLE
	static void PopulateTables();

private:
	int gridSize;
};

#endif
