#ifndef PIXEL_H
#define PIXEL_H

#define PIXELCHANNELS 3
#ifdef PIX16
# define PIXELSIZE 2
# define PIXPACK(x) ((((x)>>8)&0xF800)|(((x)>>5)&0x07E0)|(((x)>>3)&0x001F))					//16bit RGB in 16bit int: ????
# define PIXRGB(r,g,b) ((((r)<<8)&0xF800)|(((g)<<3)&0x07E0)|(((b)>>3)&0x001F))
# define PIXR(x) (((x)>>8)&0xF8)
# define PIXG(x) (((x)>>3)&0xFC)
# define PIXB(x) (((x)<<3)&0xF8)
#else
# define PIXELSIZE 4
# ifdef PIX32BGRA
#  define PIXPACK(x) ((((x)>>16)&0x0000FF)|((x)&0x00FF00)|(((x)<<16)&0xFF0000))				//24bit BGR in 32bit int: 00BBGGRR
#  define PIXRGB(r,g,b) (((b)<<16)|((g)<<8)|((r)))// (((b)<<16)|((g)<<8)|(r))
#  define PIXR(x) ((x)&0xFF)
#  define PIXG(x) (((x)>>8)&0xFF)
#  define PIXB(x) ((x)>>16)
# else
#  ifdef PIX32BGRA
#   define PIXPACK(x) ((((x)>>8)&0x0000FF00)|(((x)<<8)&0x00FF0000)|(((x)<<24)&0xFF000000))		//32bit BGRA in 32bit int: BBGGRRAA
#   define PIXRGB(r,g,b) (((b)<<24)|((g)<<16)|((r)<<8))
#   define PIXR(x) (((x)>>8)&0xFF)
#   define PIXG(x) (((x)>>16)&0xFF)
#   define PIXB(x) (((x)>>24)&0xFF)
#  else
#   define PIXPACK(x) (x)																		//24bit RGB in 32bit int: 00RRGGBB.
#   define PIXRGB(r,g,b) (((r)<<16)|((g)<<8)|(b))
#   define PIXR(x) (((x)>>16)&0xFF)
#   define PIXG(x) (((x)>>8)&0xFF)
#   define PIXB(x) ((x)&0xFF)
#  endif
# endif
#endif

#ifdef PIX16
typedef unsigned short pixel;
#else
typedef unsigned int pixel;
#endif

#endif // PIXEL_H
